/*
 Greeting message for AMRAD 40th Annniversary Meeting
 Adapted for I2C interface and easier message entry
 by Karl Berger, W4KRL
 7 May 2015 
 
 Based on large font created
 by Michael Pilcher
 2/9/2010
 http://www.instructables.com/id/Custom-Large-Font-For-16x2-LCDs/

 Recommend use of LiquidCrystal_I2C library from dfRobot.
 Download LiquidCrystal_I2C library at
 http://www.dfrobot.com/wiki/index.php/I2C/TWI_LCD1602_Module_%28SKU:_DFR0063%29#Library_Support_Functions

 Works with displays compatible with the
 Hitachi HD44780 driver.

 The Circuit: b
 LCD      Arduino
 GND ---> GND
 VCC ---> 5V
 SDA ---> A4
 SCL ---> A5

*/

#include <Wire.h>
#include <LiquidCrystal_I2C.h>

// change I2C address as appropriate for serial adapter board
// YwRobot adapter is hardwired for 0x27

// Instantiate the LCD display
// (I2C address, characters, rows)
LiquidCrystal_I2C lcd(0x27, 16, 2);

// These 8 arrays form each segment of the custom numbers
// Supplement these 8 patterns with 254 for all off and 255 for all on
byte LT[8] =
{
  B00111,
  B01111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111
};

byte UB[8] =
{
  B11111,
  B11111,
  B11111,
  B00000,
  B00000,
  B00000,
  B00000,
  B00000
};
byte RT[8] =
{
  B11100,
  B11110,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111
};
byte LL[8] =
{
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B01111,
  B00111
};
byte LB[8] =
{
  B00000,
  B00000,
  B00000,
  B00000,
  B00000,
  B11111,
  B11111,
  B11111
};
byte LR[8] =
{
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11111,
  B11110,
  B11100
};
byte UMB[8] =
{
  B11111,
  B11111,
  B11111,
  B00000,
  B00000,
  B00000,
  B11111,
  B11111
};
byte LMB[8] =
{
  B11111,
  B00000,
  B00000,
  B00000,
  B00000,
  B11111,
  B11111,
  B11111
};

void setup()
{
  lcd.init();
  lcd.backlight();
  // assigns each segment a write number
  lcd.createChar(8, LT);
  lcd.createChar(1, UB);
  lcd.createChar(2, RT);
  lcd.createChar(3, LL);
  lcd.createChar(4, LB);
  lcd.createChar(5, LR);
  lcd.createChar(6, UMB);
  lcd.createChar(7, LMB);

  lcd.begin(0, 2);
}

void loop()
{
  lcd.setCursor(3, 0);               // center the Welcome to message
  lcd.print("Welcome to");
  lcd.setCursor(0, 1);               // start the second line on the left edge
  lcd.print("AMRAD's");
  delay(250);
  for (int i = 0; i < 1; i++) {
    for (int j = 1; j < 9; j++) {
      lcd.clear();
      lcd.setCursor(3, 0);
      lcd.print("Welcome to");
      lcd.setCursor(j, 1);
      lcd.print("AMRAD's");
      delay(250);
    }
    for (int j = 9; j >= 0; j--) {
      lcd.clear();
      lcd.setCursor(3, 0);
      lcd.print("Welcome to");
      lcd.setCursor(j, 1);
      lcd.print("AMRAD's");
      delay(250);
    }
  }

for (int i = 0; i < 3; i++){
  lcd.clear();
  int x = 0;
  message1(x);
  delay(800);
  lcd.clear();
  delay(200);
  }  
  for (int i = 0; i < 3; i++){
    lcd.setCursor(2, 0);
    lcd.print("Anniversary!");
    delay(250);
    lcd.clear();
    lcd.setCursor(2, 1);
    lcd.print("Anniversary!");
    delay(250);   
    lcd.clear();
  }
  delay(800);
}

// here is where you put your large font message
// the display can buffer only XXX segements
void message1(int& pos)
{
  pos = 0;
  custom4(pos);
  custom0(pos);
  customT(pos);
  customH(pos);
}

//===================================================
// definitions of the large characters follow
// adapted from Pilcher's code to return the
// cursor position incremented by the character width
//===================================================

void custom0(int& x)  // int& passes the value of x back to the calling function
{ // uses segments to build the number 0
  // start with the top row
  lcd.setCursor(x, 0);
  lcd.write(8);  // upper left
  lcd.write(1);  // upper middle
  lcd.write(2);  // upper right
  // then move to the bottom row
  lcd.setCursor(x, 1);
  lcd.write(3);  // lower left
  lcd.write(4);  // lower middle
  lcd.write(5);  // lower right
  x = x + 4;     // move 4 blocks right
}

void custom1(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(2);
  lcd.setCursor(x + 1, 1);
  lcd.write(255);  // this is a solid 5 x 8 block
  x = x + 3;
}

void custom2(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(6);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(7);
  lcd.write(7);
  x = x + 4;
}

void custom3(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(6);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(7);
  lcd.write(7);
  lcd.write(5);
  x = x + 4;
}

void custom4(int& x)
{ // modified to look less like Y
  lcd.setCursor(x, 0);
  lcd.write(255);
//  lcd.write(3);
  lcd.write(4);
  lcd.write(255);
//  lcd.write(2);
  lcd.setCursor(x + 2, 1);
  lcd.write(255);
  x = x + 4;
}

void custom5(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(6);
  lcd.setCursor(x, 1);
  lcd.write(7);
  lcd.write(7);
  lcd.write(5);
  x = x + 4;
}

void custom6(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(6);
  lcd.write(6);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(7);
  lcd.write(5);
  x = x + 4;
}

void custom7(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(1);
  lcd.write(2);
  lcd.setCursor(x + 1, 1);
  lcd.write(8);
  x = x + 4;
}

void custom8(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(7);
  lcd.write(5);
  x = x + 4;
}

void custom9(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x + 2, 1);
  lcd.write(255);
  x = x + 4;
}

void customA(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  lcd.write(255);
  x = x + 4;
}

void customB(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(5);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(7);
  lcd.write(2);
  x = x + 4;
}

void customC(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(1);
  lcd.write(1);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(4);
  lcd.write(4);
  x = x + 4;
}

void customD(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(1);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(4);
  lcd.write(5);
  x = x + 4;
}

void customE(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(6);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(7);
  lcd.write(7);
  x = x + 4;
}

void customF(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(6);
  lcd.setCursor(x, 1);
  lcd.write(255);
  x = x + 4;
}

void customG(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(1);
  lcd.write(1);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(4);
  lcd.write(2);
  x = x + 4;
}

void customH(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(4);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  lcd.write(255);
  x = x + 4;
}

void customI(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(255);
  lcd.write(1);
  lcd.setCursor(x, 1);
  lcd.write(4);
  lcd.write(255);
  lcd.write(4);
  x = x + 4;
}

void customJ(int& x)
{
  lcd.setCursor(x + 2, 0);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(4);
  lcd.write(4);
  lcd.write(5);
  x = x + 4;
}

void customK(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(4);
  lcd.write(5);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  lcd.write(2);
  x = x + 4;
}

void customL(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(4);
  lcd.write(4);
  x = x + 4;
}

void customM(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(3);
  lcd.write(5);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  lcd.write(254);
  lcd.write(255);
  x = x + 5;
}

void customN(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(2);
  lcd.write(254);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  lcd.write(3);
  lcd.write(5);
  x = x + 5;
}

void customO(int& x)
{ // uses segments to build the letter O
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(1);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(4);
  lcd.write(5);
  x = x + 4;
}

void customP(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(255);
  x = x + 4;
}

void customQ(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(1);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(4);
  lcd.write(255);
  lcd.write(4);
  x = x + 5;
}

void customR(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(255);
  lcd.write(254);
  // lcd.write(1);
  lcd.write(2);
  x = x + 4;
}

void customS(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(8);
  lcd.write(6);
  lcd.write(6);
  lcd.setCursor(x, 1);
  lcd.write(7);
  lcd.write(7);
  lcd.write(5);
  x = x + 4;
}

void customT(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(255);
  lcd.write(1);
  lcd.setCursor(x, 1);
  lcd.write(254);
  lcd.write(255);
  x = x + 4;
}

void customU(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(254);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(4);
  lcd.write(5);
  x = x + 4;
}

void customV(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(3);
  lcd.write(254);
  lcd.write(254);
  lcd.write(5);
  lcd.setCursor(x + 1, 1);
  lcd.write(2);
  lcd.write(8);
  x = x + 5;
}

void customW(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.write(254);
  lcd.write(254);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(3);
  lcd.write(8);
  lcd.write(2);
  lcd.write(5);
  x = x + 5;
}

void customX(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(3);
  lcd.write(4);
  lcd.write(5);
  lcd.setCursor(x, 1);
  lcd.write(8);
  lcd.write(254);
  lcd.write(2);
  x = x + 4;
}

void customY(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(3);
  lcd.write(4);
  lcd.write(5);
  lcd.setCursor(x + 1, 1);
  lcd.write(255);
  x = x + 4;
}

void customZ(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(6);
  lcd.write(5);
  lcd.setCursor(x, 1);
  lcd.write(8);
  lcd.write(7);
  lcd.write(4);
  x = x + 4;
}

// question mark
void customqm(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(1);
  lcd.write(6);
  lcd.write(2);
  lcd.setCursor(x, 1);
  lcd.write(254);
  lcd.write(7);
  x = x + 4;
}

// exclamation mark
void customsm(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(255);
  lcd.setCursor(x, 1);
  lcd.write(7);
  x = x + 4;
}

// double space
void customspc(int& x)
{
  lcd.setCursor(x, 0);
  lcd.write(254);
  lcd.write(254);
  lcd.setCursor(x, 1);
  lcd.write(254);
  lcd.write(254);
  x = x + 2;
}




