;
; *****************************************************************************
; *                                                                           *
; * Purpose:  This routine sends the AD9850 control word to the DDS chip      *
; *           using a serial data transfer.                                   *
; *                                                                           *
; *   Input:  AD9850_4 ... AD9850_0                                           *
; *                                                                           *
; *  Output:  The DDS chip register is updated.                               *
; *                                                                           *
; *****************************************************************************
;
send_dds_word
        movlw   AD9850_0         	 ; Point FSR at AD9850
        movwf   FSR              	 ; 
next_byte
        movf    INDF,w           	 ; 
        movwf   byte2send         	; 
        movlw   0x08              	; Set counter to 8
        movwf   bit_count         	; 
next_bit
        rrf     byte2send,f       	; Test if next bit is 1 or 0
        btfss   STATUS,B_C        	; Was it zero?
        goto    send0             	; Yes, send zero
        bsf     PortB,7           	; No, send one
        bsf     PortB,5           	; Toggle write clock 
        bcf     PortB,5           	; 
        goto    break             	; 
send0
        bcf     PortB,7            ; Send zero
        bsf     PortB,5           ; Toggle write clock
        bcf     PortB,5           ;
break
        decfsz  bit_count,f       ; Has the whole byte been sent?
        goto    next_bit          ; No, keep going.
        incf    FSR,f             ; Start the next byte unless finished
        movlw   AD9850_4+1        ; Next byte (past the end)
        subwf   FSR,w             ; 
        btfss   STATUS,B_C        ;
        goto    next_byte         ;
        bsf     PortB,0           ; Send load signal to the AD9850
        bcf     PortB,0           ; 
        return                    ;
