/****************************************************************************
*																			*
*		FILE eeprom.h.	DDS EEPROM definitions.	Version 1.0					*
*																			*
*****************************************************************************
*	By Terry Fox, WB4JFI		tfox@knology.net							*
*																			*
*	Used to declare various EEPROM Storage locations and values				*
*	on PIC processors being used with DDS chips								*
*																			*
*****************************************************************************
*	Created June 10, 2007													*
*****************************************************************************
*	Change history:															*
*	6/12/07		Changed TXENABLE (0x36) values to match TxEnable variable	*
*				Added eEPROMWREN write-enable flage to Board State (0x15)	*
*	6/17/07		Added BP filter storage items at end (0x47-0x49)			*
*	7/10/07		Added Board state valid bits mask (0xD7)					*
*	7/11/07		Synced TxENABLES with commands, & actual code				*
*	7/12/07		Added UART baud rate storage (also enables/disables UART	*
*	7/15/07		Changed AD9832-AD9912 defines to add AD9833 & AD9912		*
*	8/31/07		Added VFO A & B storage locations							*
*	9/11/07		Added VFO C storage location								*
*	9/12/07		First cut at filter and frequency memory storage locations	*
*	9/12/07		Added callsign storage locations							*
*	9/12/07		First cut at VFO mode, RIT, & sweep storage & parameters.	*
*	9/14/07		Added eUBWDDS board ID definition (0x10)					*
*	9/14/07		Modified filter and freq EEPROM storage						*
*	9/17/07		Added eINIBANDG (initial Band) parameters (0x24)			*
****************************************************************************/
#ifndef	EEPROM_H
#define	EEPROM_H

#define	eNULL		0x00		// EEPROM data location has no data
#define	eRESERVED	0x00		// Location reserved for now, set to 00
#define	eEMPTY		0xFF		// EEPROM data location is empty (erased)
#define eEMPTYL		0xFFFFFFFF	// EEPROM empty value (unsigned long)

#define	eBOARDID	0x00		// Board ID EEPROM location - identifies board
#define	eWB6DHW1	0x01			// ID of David Brainerd DDS prototype board
#define	eWB6DHW2	0x02			// ID of David Brainerd DDS PRODUCTION board
#define	eUBWDDS		0x10			// USB bit whacker and DDS combo
#define	eWB4JFI1	0x80			// ID of Terry Fox Prototype DDS board

#define	eSWID		0x01		// Software ID EEPROM location
#define	eW2TER		0x01			// Tom, W2TER original software
#define	eW2TERTF	0x02			// Tom, W2TER software mod by TFOX
#define	eWB4JFI		0x80			// Terry, WB4JFI software

#define	eSWMAJOR	0x02		// Software major revision number
#define	eSWMINOR	0x03		// Software minor revision number
#define	eSNMSB		0x04		// Board Serial number, most-significant byte
#define	eSNLSB		0x05		// Board serial number, least-significant byte

#define	eDDSID		0x06		// onboard DDS ID (00 is reserved, not used)
#define	eDDSNONE	0x00			// no DDS, reserved
#define	eAD9850		0x01			// AD9850 DDS, usually on DDS-30, 120MHz
#define	eAD9851		0x02			// AD9851 DDS, usually on DDS-60, 30MHz X6
#define	eAD9854		0x03			// AD9854 I/Q DDS, usually on IQPro board
#define	eAD995x		0x04			// AD9951 to AD9954, used on WB6DHW board
#define	eAD9958		0x05			// AD9858 DDS
#define	eAD9832		0x06			// AD9832 (25MHz) or AD9835 (50MHz) on WB4JFI
#define	eAD9833		0x07			// AD9833 (25MHz) DDS Cash Olsen and other?
#define	eAD9834		0x08			// AD9834B (50MHz) or AD9834C (75MHz) DDS
#define	eAD9912		0x09			// AD9912 as it comes out

							// Master clock freq. into DDS, before DDS multiplier
#define	eMASOSC0	0x07		// Master oscillator into DDS LSB
#define	eMASOSC1	0x08		// bits 8-15 of 40-bit value (right justified)
#define	eMASOSC2	0x09		// bits 16-23 of 40-bit binary value
#define	eMASOSC3	0x0A		// bits 24-31 of 40-bit binary value
#define	eMASOSC4	0x0B		// bite 32-39 of 40-bit value(rarely used)
							// put 125MHz (07 73 59 40) equates here?

#define	eDDSMULT	0x0C	// DDS mulltipliers.  bits 0-4 are DDS multiplier
#define	eDDSPLL		0x1F		//	mask for internal DDS PLL value
#define	eDDSRMULT	0xE0		//  mask bits 5-7 are RF output mult

#define	eDDSINIT0	0x0D		// DDS initialization first byte storage

#define	eDDSMODEF	0x0E		// DDS frequency operating mode
#define	eDDSSNGLF	0x00			// single frequency mode
#define	eDDSSWPUF	0x01			// DDS sweep frequency UP mode
#define	eDDSSWPDF	0x02			// DDS sweep frequency DOWN mode
#define	eDDSSWUDF	0x03			// DDS sweep frequency up & down mode

#define	eDDSMODEA	0x0F		// DDS amplitude operating mode
#define	eDDSSNGLA	0x00			// DDS single amplitude mode
#define	eDDSRMPUA	0x01			// DDS ramp-UP amplitude mode
#define	eDDSRMPDA	0x02			// DDS ramp-DOWN amplitude mode

							// not used in all applications.  Some software puts the
							// 1Hz value in here, and multiplies that by wanted freq.
#define	eREFOSC0	0x10		// Reference oscillator LSB value, 40-bits binary
#define	eREFOSC1	0x11		// reference oscillator value, bits 8-15
#define	eREFOSC2	0x12		// reference oscillator value, bits 16-23
#define	eREFOSC3	0x13		// reference oscillator value, bits 24-31
#define	eREFOSC4	0x14		// reference oscillator value, bits 32-39 (rarely used)

///////////////////////////////////////////////////////////////////////////////////////////
////	eBDSTATE is synced with cmBDINIT cmd, byte[0], and BD_state in actual code		///
///////////////////////////////////////////////////////////////////////////////////////////
#define	eBDSTATE	0x15		// Board state.  Holds several flags. 0x80=USB responses on
								// 0x40=LEDheartbeat on, 0x20 always 0, 0x10=Tx pins on
								// 0x08 always 0, 0x01=EEPROM Write enable
#define	eBDSVALID	0xD7			// EEPROM Board State valid bits mask (bits 5 & 3 = 0)
#define	eUSBRESP	0x80			// USB responses can be sent to host if 1, none if 0
#define	eLEDHEART	0x40			// LED heartbeat on is set, off if cleared
#define	eTXPINSON	0x10			// Global Transmit in & out pins enabled if set
#define	eEPRMWREN	0x01			// EEPROM writes enabled if set
#define	eBDSTBAD	0x28			// Bad Board state bits,Bits 5 and 3 should always be 0

///////////////////////////////////////////////////////////////////////////////////////////
////	eOFSMODE is synced with Ofs_mode variable storage.  It shows how the Rx and Tx	///
////							offsets are added/subtracted from the display freq.		///
///////////////////////////////////////////////////////////////////////////////////////////
#define	eOFSMODE	0x16		// Receive (bits 0-3) and Transmit (bits 4-7) offset mode
#define	eOFSRMSK	0x0F		// Receive offset mode mask in bits 0-3
#define	eOFSTMSK	0xF0		// Transmit offset mode mask in bits 4-7
#define	eOFSNOFS	0x00		// No offset should be used
#define	eOFSMDPO	0x01		// Calculation should be dds_display PLUS Offset
#define eOFSMDMO	0x02		// Calculation should be dds_display MINUS Offset
#define eOFSMOMD	0x03		// Calculation should be Offset MINUS dds_display
#define	eOFSNONE	0x0F		// No offset should be used, EEPROM is blank


#define	eUARTBAUD	0x17		// UART baud rate storage (0x00 = no UART operation)

#define	eMINOUTF0	0x18		// Minimum DDS output frequency allowed, LSB
#define	eMINOUTF1	0x19		// minimum DDS output freq, 32-bit binary, bits 8-15
#define	eMINOUTF2	0x1A		// minimum DDS output freq, 32-bit binary, bits 16-23
#define	eMINOUTF3	0x1B		// minimum DDS output freq, MSB, bits 24-31

#define	eMAXOUTF0	0x1C		// maximum DDS output frequency allowed, LSB
#define	eMAXOUTF1	0x1D		// maximum DDS output freq, 32-bit binary, bits 8-15
#define	eMAXOUTF2	0x1E		// maximum DDS output freq, 32-bit binary, bits 16-23
#define	eMAXOUTF3	0x1F		// maximum DDS output freq, MSB, bits 24-31

#define	eINIFREQ0	0x20		// Initial power-up DDS operating frequency LSB
#define	eINIFREQ1	0x21		// Initial power-up DDS freq, bits 8-15, 32-bit binary
#define eINIFREQ2	0x22		// initial power-up DDS freq, bits 16-23, 32-bit binary
#define	eINIFREQ3	0x23		// initial power-up DDS freq, MSB, bits 24-31

///////////////////////////////////////////////////////////////////////////////////////////
////	eINIBANDG is synced with HamBand variable storage.  It shows the current band	///
///////////////////////////////////////////////////////////////////////////////////////////
#define	eINIBANDG	0x24		// initial band information - general band info
#define	e160M		0x00			// 160 Meters
#define	e80M		0x01			//  80 Meters
#define e60M		0x02			//  60 Meters
#define	e40M		0x03			//  40 Meters
#define	e30M		0x04			//  30 Meters
#define e20M		0x05			//  20 Meters
#define e17M		0x06			//  17 Meters
#define e15M		0x07			//  15 Meters
#define e12M		0x08			//  12 Meters
#define e10M		0x09			//  10 Meters
#define e6M			0x0A			//   6 Meters
#define	eGENM		0x0B			//  General Coverage

#define	eINIBANDF	0x25		// initial band information for filter bank switching

#define	eINIINCR0	0x26		// Initial freq increment(or sweep) 32-bit value, LSB
#define	eINIINCR1	0x27		// Initial freq increment(or sweep) 32-bit value,bits 8-15
#define	eINIINCR2	0x28		// Initial freq increment(or sweep) 32-bit value,bits 16-23
#define	eINIINCR3	0x29		// Initial freq increment(or sweep) 32-bit value,bits 24-31

#define	ePHASEI0	0x2A		// Initial I phase 16-bit binary, LSB
#define	ePHASEI1	0x2B		// Initial I phase 16-bit binary, MSB
#define	ePHASEQ0	0x2C		// initial Q phase 16-bit binary, LSB
#define	ePHASEQ1	0x2D		// initial Q phase 16-bit bimary, MSB

								// output offset can be used for receive IF display
#define	eOUTOFS0	0x2E		// output frequency offset LSB 32-bit binary
#define	eOUTOFS1	0x2F		// output frequency offset, bits 8-15
#define eOUTOFS2	0x30		// output frequency offset, bits 16-23
#define	eOUTOFS3	0x31		// output freq offset, bits 24-31 MSB
								// Note bit 31 is a sign bit, 1=subtract offset, 0=add
								
#define eTXOFS0		0x32		// Transmit frequency offset, 32-bit, LSB
#define	eTXOFS1		0x33		// transmit frequency offset, bits 8-15
#define	eTXOFS2		0x34		// transmit frequency offset, bits 16-23
#define	eTXOFS3		0x35		// transmit frequency offset MSB, bits 24-31
								// Note bit 31 is a sign bit, 1=subtract offset, 0=add

///////////////////////////////////////////////////////////////////////////////////////
////	eTXENABL synced with cmTXHWINI, byte[0] and TxEnables in actual code		///
///////////////////////////////////////////////////////////////////////////////////////
#define	eTXENABL	0x36		// Transmit enable flag.
#define	eTXNOTOK	0x00			// 00 means transmitting is not allowed
#define	eTXINPON	0x01			// 01 enables Tx In pin operation
#define	eTXOUTPN	0x02			// 02 enables Tx Out pin operation
#define	eTXHTMOUT	0x04			// 04 enables Tx HW timer in PIC
#define	eTXHRTDLY	0x08			// 08 enables Tx timer for Rx->Tx transition delay
#define	eTXHTRDLY	0x10			// 10 enables Tx timer for Tx->Rx transition delay
#define	eTXHNNOT	0x20			// 20 is not allowed for command, or EEPROM storage
#define	eTXHWPOK	0x40			// 40 means transmitting via hardware is allowed
#define	eTXUSBOK	0x80			// 80 means TX control via USB is allowed

//////////////////////////////////////////////////////////////////////////////////////
////	eTXHWPIN synced with cmTXHWINI, byte[1] and TxHwPin in actual code			//
//////////////////////////////////////////////////////////////////////////////////////
#define	eTXHWPIN	0x37		// Transmit hardware input and output pins info
#define	eTXINPIN	0x03			// mask for Tx hardware input pin
#define	eTXINPOL	0x04			// mask for TX input pin polarity flag
#define	eTXOUTPRT	0x08			// Mask for Tx output pin port (0=PortB, 1=PortC)
#define	eTXOUTPIN	0x70			// mask for TX output pin
#define	eTXOUTPOL	0x80			// mask for TX output pin polarity flag

#define	eTXDELAY	0x38		// Transmit on/off delay value (in 10msec increments)
#define	eTXTMOUT	0x39		// Transmit timeout value (in 1 second increments)

#define	eTXMODE		0x3A		// Transmit mode of operation
#define	eTXCONT		0x00			// transmit continuous carrier mode
#define	eTXMCW		0x01			// transmit CW mode
#define	eTXMFSK		0x02			// transmit FSK mode (includes RTTY)
#define	eTXMBPSK	0x03			// transmit BPSK mode
#define	eTXPSK31	0x04			// transmit PSK-31 mode
#define	eTXMLSB		0x05			// transmit lower-sideband mode
#define	eTXMUSB		0x06			// transmit upper-sideband	mode
#define	eTXMDIGI	0x07			// transmit digital modulation (escape char)

#define	eATTENVT	0x3B		// Variable attenuator type storage
#define	eATTENNO	0x00			// 00 means no variable attenuator
#define	eATTENAT	0x01			// 01 means a Honeywell HRF-AT4611
#define	eATTENH4	0x02			// 02 means a Hittite HMC542LP4 attenuator

#define	eATTILVL	0x3C		// Initial variable attenuator level
#define	eATHMASK	0x3F			// Honeywell AT4611 Value mask (six bits of data)

#define	eATTFXDL	0x3D		// Reserved for fixed attenuator information
#define	eLGAMPM0	0x3E		// Log amplifier minimum offset value, 16-bit binary, LSB
#define	eLGAMPM1	0x3F		// Log amplifier minimum offest value, 16-bit binary, MSB

#define	eINIPH0		0x40		// Initial phase adjustment, 16-bit binary, LSB
#define	eINIPH1		0x41		// Initial phase adjustment, 16-bit binary, MSB

#define	eADENABL	0x42		// A/D converter enable
#define	eADLOGIN	0x43		// A/D converter input (PIC pin) from log-amp output
#define	eADAUXIN	0x44		// A/D converter aux input (PIC pin)
#define	eADTMR0		0x45		// A/D converter timer value, LSB, in 10msec
#define	eADTMR1		0x46		// A/D converter timer value, MSB, in 10msec

								// Bandpass filter storage bytes (3 bytes total)
#define	eFLTRTYPE	0x47		// Bandpass filter type
#define	eFLTRNONE	0x00			// 0x00 means there are no filters for PIC to control
#define	eFLTRDHW	0x01			// 0x01 means a WB6DHW Bandpass filter
#define	eFLTRGEN	0x80			// 0x80 means a generic filter (4-bit band data)
#define	eFLTRHWB	0x48		// Bandpass filter bits used 1=use bit (lsb sets bits)
#define	eFLTRHWP	0x49		// Bandpass filter port used (A=1, B=2, c=3, D=4, E=5)

#define	eFVFO_A0	0x4A		// VFO A storage, byte 0
#define	eFVFO_A1	0x4B			// VFO A storage, byte 1
#define	eFVFO_A2	0x4C			// VFO A storage, byte 2
#define	eFVFO_A3	0x4D			// VFO A storage, byte 3

#define	eFVFO_B0	0x4E		// VFO B storage, byte 0
#define	eFVFO_B1	0x4F			// VFO B storage, byte 1
#define eFVFO_B2	0x50			// VFO B storage, byte 2
#define	eFVFO_B3	0x51			// VFO B storage, byte 3

#define	eFVFO_C0	0x52		// VFO C storage, byte 0	Normally a Calibrate freq
#define	eFVFO_C1	0x53			// VFO C storage, byte 1
#define eFVFO_C2	0x54			// VFO C storage, byte 2
#define	eFVFO_C3	0x55			// VFO C storage, byte 3

/****************************************************************************************
*	Callsign storage.  Room for up to ten characters of callsign						*
****************************************************************************************/
#define	eCALL_0		0x56		// Callsign storage, first byte
#define	eCALL_1		0x57		// Callsign storage, second byte
#define	eCALL_2		0x58		// Callsign storage, third byte
#define	eCALL_3		0x59		// Callsign storage, fourth byte
#define	eCALL_4		0x5A		// Callsign storage, fifth byte
#define	eCALL_5		0x5B		// Callsign storage, sixth byte
#define	eCALL_6		0x5C		// Callsign storage, seventh byte
#define	eCALL_7		0x5D		// Callsign storage, eighth byte
#define	eCALL_8		0x5E		// Callsign storage, ninth byte
#define	eCALL_9		0x5F		// Callsign storage, tenth byte

/****************************************************************************************
*	VFO Sources and RIT Storage area.  synced with VFO_sources variable, and cmVFO_SET	*
****************************************************************************************/
#define	eVFO_SRC	0x60		// VFO source storage. Receive(bits 0-3) Transmit(bits 4-7)
#define	eVFO_A		0x01			// Source is VFO A (normally receive in split mode)
#define	eVFO_B		0x02			// Source is VFO B (normally transmit in split mode)
#define	eVFO_C		0x03			// Source is VFO C (normally calibrate frequency)
#define	eVFO_D		0x04			// Source is VFO D
#define	eVFO_M		0x05			// Source is Memory location pointed to by MEM
#define	eVFO_DDS	0x06			// Source it temporary DDS work variable
#define	eVFO_DFLT	0x11			// source for Rx & Tx is VFO A to start

#define	eVFODWL		0x61		// VFO Scan dwell speed storage, low byte
#define eVFODWH		0x62		// VFO scan dwell speed storage, bigh byte
#define eVFORTM		0x63		// VFO RIT initial mode (on/off) storage
#define eVFORTL		0x64		// VFO RIT initial amount, low byte
#define	eVFORTH		0x65		// VFO RIT initial amount, high byte

#define	eSWPSP0		0x66		// Sweep speed storage, byte 0
#define	eSWPSP1		0x67		// Sweep speed storage, bute 1

/****************************************************************************************
*	BP Filter Table storage.  There can be up to 16 filter elements, the first table	*
*							entry indicates how many filters there currently are.		*
*							Each filter is described as a start frequency, followed by	*
*							a stop frequency, each of which are 16-bits (2 bytes) long.	*
*							A table entry is the 16-bit binary representation of a		*
*							a 28-bit binary number describing the frequency.  The lower	*
*							twelve bits are eliminated by shifting the frequency down	*
*							twelve bits.  Then, only 16-bits are allowed.  For example:	*
*							0x0x262, 0x03E6 describes a bandpass filter with a passband	*
*							from 2,498,560Hz to 4,087,808Hz.	Other examples:			*
*								0x0000, 0x0000	open or terminated, no feedthrough		*
*								0x0000, 0x06AC	Low-pass filter: 0Hz - 6,995,968MHz		*
*								0x0186, 0x0262	Bandpass filter: 1,597,400-2,498,560	*
*								0x1C53, 0xFFFF	High-pass filter: 29,700,096 - TOP		*
*								0x0000, 0xFFFF	All-pass filter (bypass), no loss		*
*								0xFFFF, 0xFFFF	open or terminated, no feedthrough		*
*							Using this method, filters up to 268.4MHz can be desribed	*
****************************************************************************************/
#define	eFLTRCNT	0x6F		// number of filters in the table
#define	eFLTRTBL	0x70		// Bandpass/lowpass filter description table base adr
								

/****************************************************************************************
*	Frequency memory table storage.  This is actually two tables.  						*
*							The first is a set of one-entry-per-band, which will allow	*
*							 the last-used frequency in each band to be saved.			*
*							The second table is a general memory storage area, starting *
*							with memory[0].												*
*							Each memory entry consists of a 32-bit binary description	*
*							of the frequency, saved as four bytes in four EEPROM		*
*							locations.  Least-significant byte is first, most is fourth *
****************************************************************************************/
#define	eBANDMEM	0xB0		// per-band frequency storage  There are a total of 12
								// per-band entries in this table, each 32-bits long
#define	eFREQMEMS	0xE0		// general frequency memory storage.  There are eight
								// memories allowed in EEPROM, each 32-bits long


//	end of eeprom.h FILE
