/************************************************************************************
*																					*
*		FILE:	tercmds.h		W2TER (& WB4JFI) PIC USB COMMANDS					*
*																					*
*************************************************************************************
*		By Tom, W2TER with additions by Terry, WB4JFI								*
*																					*
*		Used to declare various commands and responses used by a					*
*		host computer to control PIC and DDS hardware								*
*																					*
*************************************************************************************
*	File created June 10, 2007	by Terry Fox, WB4JFI								*
*************************************************************************************
*	Change history:																	*
*	6/12/07				Added EEPROM Read questionable, if read byte FF				*
*						Added EEPROM Write flag in Board init command				*
*	6/17/07				Added WB6DHW Bandpass Filter control command				*
*	7/10/07				Added USB transmit ON/OFF and enable command				*
*	7/11/07				Cleaned up Tx HW pins, synced TXENABLES						*
*	7/12/07				Added Uart Transmit enable									*
*	7/15/07				Changed AD9832-AD9912 defines to add AD9833	& 9912			*
*	8/07/07				Added Master osc and DDS PLL, Mult commands					*
*	8/30/07				Added Master Oscillator calibrate command					*
*	8/31/07				Reversed Mas. Osc and Freq set commands (7A & 79)			*
*	8/31/07				Added (officially) Get Parameter command (78)				*
*	9/01/07				Added set parameter and VFO commands (0x76)					*
*	9/06/07				Added BP Filter parameter setting command (F9)				*
*	9/06/07				Added MODE commands skeleton only (75 & F5)					*
*	9/08/07				Modified and got working Set parameter cmd (0x77)			*
*	9/17/07				Modified and got working VFO mode (0x76)					*
*	9/17/07				Added Band Set command (0x74)								*
************************************************************************************/
#ifndef	TERCMDS_H
#define	TERCMDS_H

#define	cmCOMMAND	0x04	// pointer to command in buffer (5th byte)
#define cmRESPONSE	0x04	// pointer to response in buffer (5th byte)
#define	cmLENGTH	0x05	// length of command & response frames


/************************************************************************************
*	Board ID Command Equates	(0x00)												*
************************************************************************************/
#define	cmBOARDID	0x00	// Board ID command.  gets initial information			(TESTED)
							// added by WB4JFI.  Works 6/10/07.
							// called with:  (no parameters)
							// returns:
#define	cmHWID		0x00		// byte[0] = hardware ID value						(TESTED)
#define	cmSWID		0x01		// byte[1] = software ID value						(TESTED)
#define	cmSWMREV	0x02		// byte[2] = software major revision				(TESTED)
#define	cmDDSID		0x03		// byte[3] = DDS chip ID							(TESTED)
#define	cmNODDSID	0x00			// No DDS on board								(TESTED)
#define	cm9850ID	0x01			// AD9850 DDS ID								(TESTED)
#define	cm9851ID	0x02			// AD9851 DDS ID								(TESTED)
#define cm9854ID	0x03			// AD9854 DDS ID
#define	cm995XID	0x04			// AD995x DDS ID								(TESTED)
#define	cm9958ID	0x05			// AD9958 DDS ID
#define	cm9832ID	0x06			// AD9832 DDS ID								(TESTED)
#define	cm9833ID	0x07			// AD9833 DDS ID								(TESTED)
#define	cm9834ID	0x08			// AD9834 DDS ID								(TESTED)
#define cm9912ID	0x09			// AD9912 DDS ID

/************************************************************************************
*	DDS frequency update Commands	(0x01-0x07)										*
************************************************************************************/
#define	cm9850UPD	0x01	// AD9850 frequency update.	Usually on DDS-30			(TESTED)
							// original W2TER command

#define	cm9851UPD	0x02	// AD9851 frequency update.  Usually on DDS-60			(TESTED)
							// original W2TER command

#define	cm9854UPD	0x03	// AD9854 frequency update.  Usually on IQPRo
							// original W2TER command

#define	cm995xUPD	0x04	// AD995x frequency update.  On WB6DHW board			(TESTED)
							// original W2TER command

#define	cm9958UPD	0x05	// AD9958 frequency update.
							// original W2TER command

#define	cm9832UPD	0x06	// AD9832 & AD9835 frequency update. On WB4JFI DDS-9	(TESTED)
							// added by WB4JFI.

#define	cm9833UPD	0x07	// AD9833 frequency update.  On Cash Olsen board		(TESTED)
							// added by WB4JFI.			or QST Nov.2005 article

#define	cm9834UPD	0x08	// AD9834 B & C frequency Update.  On NorCal FCC-2		(TESTED)
							// added by WB4JFI.  Normally 50MHz.  WB4JFI mod 75M

#define cm9912UPD	0x09	// AD9912 frequency update.
							// added by WB4JFI.  Not implemented yet

/****************************************************************************************
*	Misc Commands																		*
****************************************************************************************/

/************************************************************************************
*	cmBAND_set		(0x74)	// Change band of operation								*
************************************************************************************/
#define	cmBAND_set	0x74	// change the current band of operation
							// added by WB4JFI 9/17/07.								(TESTED)
#define	cmBAND		0x00	// byte[0] contains the new band data

#define	cmBANDWR	0x80		// bit 7 is set to store new band as startup in EEPROM
#define	cmB160M		0x00		// change band to 160 Meters
#define	cmB80M		0x01		// change band to 80 Meters
#define cmB60M		0x02		// change band to 60 Meters
#define	cmB40M		0x03		// change band to 40 Meters
#define	cmB30M		0x04		// change band to 30 Meters
#define cmB20M		0x05		// change band to 20 Meters
#define cmB17M		0x06		// change band to 17 Meters
#define cmB15M		0x07		// change band to 15 Meters
#define cmB12M		0x08		// change band to 12 Meters
#define cmB10M		0x09		// change band to 10 Meters
#define cmB6M		0x0A		// change band to  6 Meters
#define	cmBGENM		0x0B		// change band to General Coverage
							// return USB data flag
#define	cmBNEMPTY	0x10		// shows EEPROM Freq was NOT empty, used it
#define	cmBTABLE	0x20		// return to show Freq data was from PGM table
#define	cmBZERO		0x40		// return to show Freq data from table was zero

/************************************************************************************
*	MODE Operate command (0x75)	Sets/enables & disables special opearating modes	*
************************************************************************************/
#define	cmMODE_SET	0x75	// enable or disable special operating modes
							// added by WB4JFI 9/6/07.  				NOT IMPLEMENTED YET

/************************************************************************************
*	VFO setup command	(0x76)	Sets the current DDS and VFO relationships			*
*								VFO A is normally the receive VFO (optional RIT)	*
*								VFO B is normally the transmit VFO					*
*								VFO C is normally the "Calibrate" frequency			*
*								VFO D is normally the DDS intermediate value		*
************************************************************************************/
#define	cmVFO_SET	0x76	// set up the current DDS & VFO relationships
							// added by WB4JFI.  9/18/07		 			PARTIALLY IMPLEMENTED
#define	cmVFO_NOC	0x00	// No VFO command in this byte (used in bytes[0] and [1])(TESTED)
#define cmVFO_EWR	0x80	// flag to indicate changes should be written to EEPROM (NOT TESTED)
								//NOTE: while this is in byte[0], it pertains to
								// byte[1] updates as well.
#define cmVFO_CMD	0x00	// byte[0] is the VFO SET subcommand, as follows:		(MOST DONE)
#define	cmVFO_A_B	0x01		// copy VFO A frequency to VFO B					(TESTED)
#define	cmVFO_B_A	0x02		// copy VFO B frequency to VFO A					(TESTED)
#define	cmVFO_SWP	0x03		// swap VFO A & B frequencies						(TESTED)
#define	cmVFO_A_M	0x04		// copy VFO A to memory (memory adr in byte[2])		(LIMITED TEST)
#define	cmVFO_M_A	0x05		// copy memory to VFO A								(LIMITED TEST)
#define	cmVFO_AMS	0x06		// swap VFO A & memory								(LIMITED TEST)
#define	cmVFO_B_M	0x08		// copy VFO B to memory (memory adr in byte[2])		(LIMITED TEST)
#define	cmVFO_M_B	0x09		// copy memory to VFO B								(LIMITED TEST)
#define	cmVFO_BMS	0x0A		// swap VFO B & memory								(LIMITES TEST)
#define	cmVFO_SAC	0x0B		// swap VFO A and VFO C (calibtrate)				(TESTED)
#define	cmVFO_SAD	0x0C		// swap VFO A and VFO D (DDS work storage)			(NOT IMPL)
#define	cmVFO_RIT	0x10		// Enables RIT function.  byte[2] & [3] hold RIT	(TESTED)
									// byte[2], bit 7 (MSb) holds sign (1=minus)	(TESTED)
#define	cmVFO_NRIT	0x11		// Turns OFF RIT function							(TESTED)
#define	cmVFO_ABS	0x12		// scan alternately VFO A and VFO B					(NOT IMPL)
#define	cmVFO_SCM	0x13		// scan memory locations							(NOT IMPL)
#define	cmVFO_NOS	0x14		// turn off any scanning							(NOT IMPL)
									// note: scan dwell time in 10msec in bytes[2]&[3]
#define	cmVFO_SRC	0x01	// byte[1] will hold current Rx & Tx frequency source	(TESTED)
								// bits 0-3 = Rx source, bits 4-7 = Tx source
								// this command syncs with VFO_sources variable
#define	cmVFO_A		0x01			// source is VFO A storage						(TESTED)
#define	cmVFO_B		0x02			// source is VFO B storage						(TESTED)
#define	cmVFO_C		0x03			// source is VFO C storage						(TESTED)
#define	cmVFO_D		0x04			// source is VFO D storage						(NOT IMPL)
#define cmVFO_M		0x05			// source is Memory location in Byte[2]			(NOT IMPL)
#define	cmVFO_DDS	0x06			// source is dds_out							(NOT IMPL)
#define	cmVFO_MEM	0x02	// byte[2] holds memory storage address for VFO memory	(LIMITED TEST)
#define	cmVFO_OFH	0x02	// byte[2] holds RIT upper amount (bit 7=sign of RIT)	(TESTED)
#define cmVFO_OFL	0x03	// byte[3] holds RIT lower amount						(TESTED)
#define	cmVFO_DWH	0x02	// byte[2] holds scan dwell time high byte (in 10ms)	(NOT IMPL)
#define cmVFO_DWL	0x03	// byte[3] holds scan dwell time low byte				(NOT IMPL)

/************************************************************************************
*	Set parameter command	(0x77)	Set a parameter for the PIC						*
************************************************************************************/
#define	cmSETPARAM	0x77	// Set a (DDS) parameter in PIC							(TESTED)
							// added by WB4JFI.  Working as of 9/8/07.
#define	cmSET_SCMD	0x00	// Subcommand is in byte[0],							(TESTED)
#define	cmSET_SMSK	0xE0	// Subcommand Mask, it is in bits 7-5 of byte[0]		(TESTED)
							// NOTE:  The three most-sig bits of (MSB) byte[0]
							// point to the parameter to set, as follows:
#define cmSET_VFOA	0x20		// Subcommand to set the VFO A storage freq			(TESTED)
#define cmSET_VFOB	0x40		// Subcommand to set the VFO B storage freq			(TESTED)
#define cmSET_VFOC	0x60		// Subcommand to set the VFO C (calibrate) freq		(TESTED)
#define cmSET_VFOD	0x80		// Subcommand to set the VFO D (dds display freq)	(TESTED)
#define cmSET_MAXF	0xA0		// subcommand to set maximum operating freq.		(TESTED)
#define	cmSET_ROFS	0xC0		// Subcommand to set the Rx offset					(TESTED)
#define	cmSET_TOFS	0xE0		// Subcommand to set the Tx offset					(TESTED)
#define	cmSET_OMSK	0x18		// Offset mode mask bits							(TESTED)
#define cmSET_OMNO	0x00		// Offset mode is NO offset							(TESTED)
#define	cmSET_OFSP	0x08		// Offset freq is added to dds display freq			(TESTED)
#define cmSET_OFSM	0x10		// Offset freq is subtracted from dds display freq	(TESTED)
#define cmSET_OFSO	0x18		// DDS display frequency is subtracted from Offset	(TESTED)
							// NOTE:  The rest of the bits of byte[0], and
							// bytes[1]-[3] hold the respective parameter value

/************************************************************************************
*	Get Parameter command	(0x78)	Get one operating parameter from the PIC		*
************************************************************************************/
#define	cmGETPARAM	0x78	// get a (DDS) parameter from PIC.						(TESTED)
							// Added by WB4JFI.  Implemented 7/07 for debugging
							// Byte[0] requests parameter for PIC to return.
							// *** NOTE: Byte[4] is the returned parameter pointer ****
							// This can confuse software that reies on byte[4] to be
							// an echo of the command.  No easy solution to this.
#define	cmGET_MOSC	0x01		// subcommand to get master oscillator frequency	(TESTED)
#define	cmGET_DCLK	0x02		// subcmd to get DDS Clock frequency (OSC X PLL)	(TESTED)
#define	cmGET_DOUT	0x03		// get DDS output freq (display X VFO Mult)			(TESTED)
#define	cmGET_DISP	0x04		// get DDS display freq (requested frequency)		(TESTED)
#define	cmGET_DFTW	0x05		// get DDS calculated Freq Tuning Word (FTW)		(TESTED)
#define	cmGET_FWRK	0x06		// get DDS Freq Work (Intermediate calculation)		(TESTED)
#define	cmGET_MAXF	0x07		// get Maximum allowed frequency (hardware limit)	(TESTED)
#define	cmGET_PLLV	0x08		// get DDS, PLL and VFO Multiplier values			(TESTED)
								// returns: byte[0]=Offset mode, byte[1]=  			(TESTED)
								// DDS PLL, byte[2]=VFO Mult, byte[3]=DDS PLL		(TESTED)
#define	cmGET_F1Hz	0x09		// get calculated 1Hz value for DDS/clock combo		(TESTED)
#define	cmGET_ROFS	0x0A		// get Receive offset frequency						(TESTED)
#define	cmGET_TOFS	0x0B		// get Transmit offset frequency					(TESTED)
#define cmGET_VFOA	0x0C		// get VFO A frequency value						(TESTED)
#define	cmGET_VFOB	0x0D		// get VFO B frequency value						(TESTED)
#define cmGET_VFOC	0x0E		// get VFO C frequency value (calibrate default)	(TESTED)
#define	cmGET_VFOD	0x0F		// get VFO D frequency value (dds display default)	(TESTED)
#define	cmGET_BPFS	0x10		// get current bandpass filter start & stop			(TESTED)
#define	cmGET_VFOM	0x11		// get VFO Mode storage, BPF type, Filter band		(TESTED)
#define cmGET_RITV	0x12		// get RIT status and value							(TESTED)
#define cmGET_BDID	0x13		// get Board ID, BD state, TxEnables, Filter type	(TESTED)
#define	cmGET_FMEM	0x14		// get Freq memory data, pointed to by byte[1]		(NOT IMPL)

								// NOTE: more may be added, or used for debugging
										// debugging values start at 0x80

/************************************************************************************
*	Set Frequency command.  (0x79)	Sets DDS frequency via PIC calculation.			*
************************************************************************************/
#define	cmSETFREQ	0x79	// Set frequency via PIC calculations					(TESTED)
							// added by WB4JFI.  Implemented 8/08/07
							// PIC calculates & sets freq (bytes 0-3, 32-bit binary)
							// byte[0] is MSB, byte[3] is LSB of frequency			(TESTED)
								// returns with actual FTW used for DDS, plus
								// returns with most-sig BIT of MSB as follows:
#define	cmSETFOK	0x80		// set freq was successful (set msb of byte[0])		(TESTED)
#define	cmSETFBAD	0x00		// set frequency failed (clear msb of byte[0])		(TESTED)

/************************************************************************************
*	Master Oscillator Calibrate command.  Allows adjustment of master osc			*
*						(0x7A)				number, to calibrate DDS frequency		*
************************************************************************************/
#define cmMOSCCAL	0x7A	// Calibrate master oscillator command					(TESTED)
							// Added by WB4JFI 8/30/07.  Works as of 9/6/07
							// command uses four most-sig BITS of most-sig BYTE		(TESTED)
#define cmOSCSCMD	0x00		// (byte[0]) as a sub-command.  Values are:			(TESTED)
#define	cmOSCSMSK	0x70		// Oscillator subcommand bit mask					(TESTED)
#define	cmOSCALRD	0x00		// Oscillator command ignore/read-back subcommand	(TESTED)
#define	cmOSCAL10	0x10		// Oscillator start calibrate subcommand @ 10MHz	(TESTED)
#define	cmOSCALAD	0x20		// Add byte[0] to [3] to present oscillator value	(TESTED)
#define cmOSCALSB	0x30		// Subtract byte[0]-[3] from present osc value		(TESTED)
#define cmOSCALWR	0x40		// calibrate complete, write new master osc value	(TESTED)
#define	cmOSCALDI	0x50		// calibrate complete, DISCARD new osc value		(TESTED)
#define	cmOSCALFR	0x70		// Osc cmd, start calibrate at requested freq		(TESTED)
#define	cmOSCALNM	0x00		// Do NOT use VFO Mult value during calibrate		(TESTED)
#define	cmOSCALYM	0x80		// YES,use VFO multiplier value during calibrate	(TESTED)
// NOTES:					// byte[0], bits 0-3, and bytes[1]-[3] are used			(TESTED)
							// to hold a 32-bit binary value, as follows:
								// 1. If sub-command 0x70, they hold requested
								// frequency to calibrate (not 10MHz).  This can
								// be used to tune the receiver to a specific
								// calibration frequency.
								// 2. For subcommands 0x20 & 0x30, they hold the
								// actual amount to add or subtract from the
								// master oscillator working value during cal.

/************************************************************************************
*	External Filter control.  (0x7B)	Normally controls WB6DHW BP filters			*
************************************************************************************/
#define	cmSETFLTR	0x7B	// Set LP/BP filters via PIC hardware					(TESTED)
							// added by WB4JFI.  Implemented 6/07
#define	cmFLTRBAND	0x00		// Filter selection is in first byte of cmd			(TESTED)
#define	cmFLTRM160	0x00			// WB6DHW BP Filter 160M (1.6-2.3MHz)			(TESTED)
#define	cmFLTRM80	0x01			// WB6DHW BP filter 80M (2.5-3.9MHz)			(TESTED)
#define	cmFLTRM5	0x02			// WB6DHW BP filter 5MHz (4.0-6.5MHz)			(TESTED)
#define	cmFLTRM40	0x05			// WB6DHW BP filter 40 & 30M (7.0-11MHz)		(TESTED)
#define	cmFLTRM20	0x06			// WB6DHW BP filter 20 & 17M (12-18MHz)			(TESTED)
#define	cmFLTRM15	0x07			// WB6DHW BP filter 15 & 10M (18-29MHz)			(TESTED)
#define	cmFLTRFEED	0x03			// filter bypass (straight through switches)	(TESTED)
#define	cmFLTRUSER	0x04			// user-defined filter (open on BP filter)		(TESTED)
#define	cmFILTERID	0x01		// second byte contains the filter identifier		(TESTED)
#define	cmDHWBPFLTR	0x01			// WB6DHW bandpass filter identifier			(TESTED)
#define	cmFILTERHW	0x02		// third byte optionally controls PIC hardware	(NOT IMPLEMENTED)

/************************************************************************************
*	Transmit ON & OFF Commands					(0x7C)								*
************************************************************************************/
#define	cmTXONOFF	0x7C	// Turns transmitter hardware on or off.  				MAY NEED
							// added by WB4JFI. Implemented 7/10/07.  				DEBUGGING
#define	cmTXONB0	0xAA		// Byte 0 flag to turn tranmsitter ON				(TESTED)
#define	cmTXONB1	0x55		// Byte 1 flag to turn transmitter ON				(TESTED)
#define	cmTXOFFB0	0x00		// Byte 0 flag to turn transmitter OFF				(TESTED)
#define	cmTXOFFB1	0x00		// Byte 1 flag to turn transmitter OFF				(TESTED)
#define	cmTXONRSP	0x55		// Response flag for Transmitter ON (in byte 0)		(TESTED)
#define	cmTXOFFRSP	0x00		// Response flag for Transmitter OFF (in byte 0)	(TESTED)
#define	cmTXCMBAD	0xFF		// Response flag for ERROR, CANNOT transmit(byte 0)	(TESTED)
#define	cmTXPIN		0x55		// transmit was a result of Tx In Pin change
#define	cmTXUSB		0xAA		// transmit was a result of USB command
#define	cmTXSER		0x11		// transmit was a result of serial UART command

/************************************************************************************
*	PIC EEPROM read & Write Command Equates		(0x7D)								*
************************************************************************************/
#define	cmRWEPROM	0x7D	// Reads or writes data to PIC EEPROM					(TESTED)
							// added by WB4JFI. Works as of 6/10/07
							// called with:
#define	cmEPROMCMD	0x00		// EEPROM command pointer, as follows:				(TESTED)
#define	cmRDEEPROM	0x01			// EEPROM read command							(TESTED)
#define	cmWREEPROM	0x02			// EEPROM write command							(TESTED)
#define	cmEPROMADR	0x01		// EEPROM address to read from or write to			(TESTED)
#define	cmEPROMDTA	0x02		// EEPROM data to write to, or read from			(TESTED)
#define	cmEPROMVFY	0x03		// EEPROM reade and write verify pointer			(TESTED)
#define	cmEPROMGUD	0x01			// EEPROM write was successful					(TESTED)
#define	cmEPROMBAD	0x00			// EEPROM write was bad							(TESTED)
#define	cmEPRMRDFF	0x02			// EEPROM read was questionable, read as 0xFF	(NOT USED)
							// see also BDInit command for eeprom write enable

/************************************************************************************
*	A/D Converter Command Equates	(0x7E)											*
************************************************************************************/
#define	cmADCMD		0x7E	// Sends PIC A/D converter command					(SOME TESTED)
							// added by WB4JFI. works (except chnl select) 6/10/07
							// called with:
#define	cmADSUBCMD	0x00		// pointer to A/D subcommand
#define	cmADSUBOFF	0x00			// turn OFF A/D converter						(TESTED)
#define	cmADSUB01	0x01			// do a single A/D conversion					(TESTED)
									// sending 02-FE as subcmd causes that # conv.	(TESTED)
#define	cmADSUBCNT	0xFF			// do continuous A/D samples, until stopped		(TESTED)
#define	cmADSEQNO	0x01		// pointer to A/D sample sequence seed number		(TESTED)
#define	cmADCHNL	0x02		// pointer to A/D channel to sample			(NOT IMPLEMENTED)
								// A/D converter hardwired to AN4/RA5 prototype,
									// or to AN0 for Production Brainerd Board
#define	cmADDEST	0x03		// pointer to A/D converter results destination		(TESTED)
#define	cmADDPIC	0x01			// send A/D samples to PIC internal use			(TESTED)
#define	cmADDUSB	0x02			// send A/D samples to host via USB				(TESTED)
#define	cmADRESL	0x02		// pointer to A/D result low byte (right justified)	(TESTED)
#define	cmADRESH	0x03		// pointer to A/D result high byte (right justified)(TESTED)

/************************************************************************************
*	Attenuator Command Equates		(0x7F)											*
************************************************************************************/
#define	cmATTNCMD	0x7F	// Set variable Attenuator level						(TESTED)
							// added by WB4JFI. Works as of 6/10/07
#define	cmATTNLVL	0x00		// pointer to variable attenuator level				(TESTED)
#define	cmATTNMSK	0x3F			// Mask for six bits of variable attenuation	(TESTED)
#define	cmATTNFX1	0x01		// pointer to fixed attenuator byte 1 (reserved) 	(NOT IMPL)
#define	cmATTNFX2	0x02		// pointer to fixed attenautor byte 2 (reserved)	(NOT IMPL)
#define	cmATTNFX3	0x03		// pointer to fixed attenuator byte 3 (reserved)	(NOT IMPL)

/************************************************************************************
*	DDS Inititalization commands	(0x80-0x86)										*
************************************************************************************/
#define	cm9850INI	0x80	// Initialize AD9850 DDS, usually on DDS-30				(TESTED)
							// original W2TER command

#define	cm9851INI	0x81	// Initialize AD9851 DDS, usually on DDS-60				(TESTED)
							// original W2TER command

#define	cm9854INI	0x82	// Initialize AD9854 DDS, usually on IQPro
							// original W2TER command

#define cm9951INI	0x83	// Initialize AD9951 DDS, usually on WB6DHW				(TESTED)
							// original W2TER command

#define	cm9958INI	0x84	// Initialize AD9958 DDS
							// original W2TER command

#define	cm9832INI	0x85	// Initialize AD9832 or AD9835, usually WB4JFI DDS-9	(TESTED)
							// added by WB4JFI.  Implemented 8/8/07

#define	cm9833INI	0x86	// Initialize AD9833 DDS, usually Cash Olsen or QST 11/05(TESTED)
							// Added by WB4JFI.  Implemented 8/8/07

#define	cm9834INI	0x87	// Initialize AD9834, usually on NorCal FCC-2			(TESTED)
							// added by WB4JFI. Implemented 8/8/07.

#define	cm9912INI	0x88	// Initialize AD9912 DDS
							// Added by WB4JFI.  Not implemented yet.

/************************************************************************************
*	MODE_INI		(0xF5)		Initialize the Board for Special Operating Modes	*
************************************************************************************/
#define	cmMODEINI	0xF5	// Initialize board for special modes (sweeps, etc)
							// Added by WB4JFI.  Sept. 7, 2007.			NOT IMPLEMENTED YET
#define	cmMOD_SCMD	0x00	// Byte[0] contains the subcommand, as follows:
#define	CMMOD_SMSK	0xF0	// bits 7-4 are subcommand mask

/************************************************************************************
*	Bandpass Filter frequency parameter Initialization	(0xF9)						*
************************************************************************************/
#define	cmBPFINI	0xF9	// Initialize a Bandpass Filter parameter
							// Added by WB4JFI.  Sept. 7, 2007.  					NOT TESTED
							// Cmd sets one bandpass filter parameter (start or stop)
#define	cmBPFSCMD	0x00	// subcommand is stored in byte[0]
#define	cmBPFCMSK	0xF8	// subcommand mask for subcommands in byte[0]
							// NOTE:  each filter has two parameters, a frequency
							// start and a frequency stop.  These are sent to the
							// PIC in byte[0], bits 2-0, and bytes[1]-[3], as a
							// 27-bit binary word, enabling filters to 134MHz
							// NOTE2: The PIC actually strips off the lower 12-bits
							// and uses only 16-bits for filter comparisons
							// NOTE3: Byte[0], bits 7-4 are the filter pointer,
							// and bit 3 is the start(0) or stop(1) selector 
/************************************************************************************
*	Master Oscillator Freq Set Initialization			(0xFA)						*
************************************************************************************/
#define	cmOSCSET	0xFA	// Initialize the DDS master oscillator frequency		(TESTED)
							// added by WB4JFI.  August 7, 2007
							// four bytes follow are the master oscillator freq
							//  EXCLUDING any multiplier.  Byte[0] is MSB, [3] LSB	(TESTED)
/************************************************************************************
*	Master Osc PLL and DDS output multiplier Initialization	(0xFB)					*
************************************************************************************/ 
#define	cmPLLMULT	0xFB	// DDS master osc PLL, and DDS out multiplier set (0xFB)(TESTED)
							// added by WB4JFI.  8/7/07
#define	cmDDSPLL	0x00		// put the actual master osc. PLL value in first byte(TESTED)
#define	cmMULT		0x01		// put the DDS output multiplier in second byte		(TESTED)

/************************************************************************************
*	Transmitter hardware In & Out initialization		(0xFC)						*
************************************************************************************/
#define	cmTXHWINI	0xFC	// Initialize Transmitter hardware IO pins		(PARTIALLY TESTED)
							// added by WB4JFI. 					Limited function 6/10/07
#define	cmTXHENAB	0x00		// pointer to individual enable flags				(TESTED)
								// NOTE: This byte syncs with eTXENABLE and TxEnables
#define	cmTXHALOFF	0x00			// turn off all Tx hardware and timers			(TESTED)
#define	cmTXHINON	0x01			// enable Tx In Pin to PIC (working)			(TESTED)
#define	cmTXHOUTON	0x02			// enable Tx Out Pin from PIC (working)			(TESTED)
#define	cmTXHTMOUT	0x04			// enable Tx timeout timer in PIC				(NOT IMPL)
#define	cmTXHRTDLY	0x08			// enable Tx Timer Rx->Tx transition delay		(NOT IMPL)
#define	cmTXHTRDLY	0x10			// enable Tx Timer Tx->Rx transition delay		(NOT IMPL)
#define	cmTXHNOCMD	0x20			// Not allowed in command, response flag only	(VERIFY?)
//#define	cmTXURTOK	0x40			// enable Tx control via serial UART			(NOT IMPL)
#define	cmTXHWPOK	0x40			// enable Tx control hardware bits				(NOT IMPL)
#define	cmTXUSBOK	0x80			// enable Tx control via USB commands			(TESTED)
#define	cmTXHSTAT	0xFF			// command to get status only - no value changes(VERIFY?)
#define	cmTXHSTRTN	0x20			// bit 5 set to show a status response only.	(VERIFY?)
#define	cmTXHPINS	0x01		// pointer to hardware pin assignments				(NOT IMPL)
									// NOTE: This byte syncs with eTXHWPIN and TxHwPin
#define	cmTXHINPIN	0x03			// Mask for Tx In Pin control bits (RB4,5,6,7)	(NOT IMPL)
#define	cmTXHINPOL	0x04			// Tx In pin polarity: 0=Tx low, 1=Tx high		(TESTED)
#define	cmTXHOPINP	0x08			// Tx Out pin Port assignment.0=PortB, 1=PortC	(NOT IMPL)
#define	cmTXHOPIN	0x70			// mask for Tx Out pin assignment (bit 0-7)		(NOT IMPL)
#define	cmTXHOPOL	0x80			// Tx Out pin polarity: 0=Tx low, 1=Tx high		(TESTED)
#define	cmTXHTMVAL	0x02		// pointer to Tx Timeout value (in 10 second increm)(NOT IMPL)
									// NOTE: This syncs with eTXDELAY in EEPROM
#define	cmTXHTMNO	0x00			// returned response that it has not timed out	(NOT IMPL)
#define	cmTXHTIMOUT	0xFF			// returned response indicating time out condition(NOT IMPL)
#define	cmTXHTDVAL	0x03		// poiner to Tx transition timer (in 10msec)		(NOT IMPL)
									// NOTE: This syncs with eTxTMOUT in EEPROM

/************************************************************************************
*	Board Initialization command		(0xFD)										*
************************************************************************************/
#define	cmBDINIT	0xFD	// Initialize PIC/DDS board as if power-up
							// added by WB4JFI. Limited function 6/10/07
#define	cmBDFLG0	0x00		// pointer to board init flags 0 (same as EEPROM BD_STATE)
									// NOTE: This syncs with eBDSTATE and BD_state
#define cmBDFRES	0xD7			// Board init flag, mask, bit 5 & 3 must be zero(VERIFY?)
#define	cmBDFUSB	0x80			// Board Init Flag, USB responses enabled		(TESTED)
#define	cmBDFLED	0x40			// Board Init Flag, LEDheartbeat enabled		(TESTED)
#define	cmBDFTXP	0x10			// Board Init flag, Tx in & out pins enabled	(TESTED)
#define	cmBDFEWR	0x01			// Board Init flag, EEPROM write enable			(TESTED)
#define	cmBDFLG1	0x01		// pointer to board init flags 1					(NOT IMPL)
#define	cmBDSTUD	0x01			// If this flag is set, update board State EEPROM(NOT IMPL)
#define	cmBDIDUD	0x02			// if this flag is set, update board ID EEPROM	(NOT IMPL)
#define cmDSIDUD	0x04			// if this flag is set, update DDS ID EEPROM	(NOT IMPL)
#define	cmBDIDUPD	0x02		// board ID update is sent in third byte			(NOT IMPL)
#define	cmBDDDSID	0x03		// Board DDS ID update is sent in fourth byte		(NOT IMPL)

/************************************************************************************
*	A/D Converter Initialization command	(0xFE)									*
************************************************************************************/
#define	cmADINIT	0xFE	// Initialize PIC A/D converter					(PARTIALLY TESTED)
							// added by WB4JFI. Works (except chnl select) 6/10/07 
#define	cmADCHANL	0x00		// pointer to PIC channel to sample with A/D		(NOT IMPL)
									// note:  channel currently fixed to AN4/RA5
									// for proto, or AN0 for production Brainerd
#define	cmADRTEL	0x01		// pointer to A/D sample rate, low half (bits 0-7) 10ms(TESTED)
#define	cmADRTEH	0x02		// pointer to A/D sample rate, high half (bits 8-15) 10ms(TESTED)
#define	cmADDEST	0x03		// pointer to A/D destination flags						(TESTED)
#define	cmADDPIC	0x01			// A/D converter results to PIC internal routines	(TESTED)
#define	cmADDUSB	0x02			// A/D converter results to host via USB			(TESTED)

/************************************************************************************
*	Board Test Command (does little actual stuff)	(0xFF)							*
************************************************************************************/
#define	cmBDTEST	0xFF	// Board test command, doesnt do anything drastic		(TESTED)
							// added by WB4JFI.  Works as of 6/10/07


/******************************		END OF TERCMDS.H FILE	******************************/
