

/*
External upper cap for the full size (2) LF antenna enclosure

		Melvin G. Seyle, Jr.
			W4MEL
		  August 8, 2018
*/

$fn=100;

cubesize = 27.95;

//Cap for the enclosure
difference() {
      
  // Cube for the cap    
  translate([0,0,0])     cube(size = [cubesize, cubesize, cubesize-10], center=false); 

  // Hollow out the the cube  
  translate([1,1,5]) cube(size = [cubesize-2., cubesize-2., cubesize-10], center=false);
    
  // Hole for cap screw #1
  translate([8.5,0,13.5]) rotate([-90,0,0]) cylinder(h=3.18 ,r=0.75);

  // A hole for the BNC connector 
  translate([13.975,13.975])     cylinder(r=4.9625,  h=5); 
}