

/*
This file is the design for a plug to fit into a one inch
piece of conduit.  The plug allows a BNC panel connector
to be inserted (inset, so that the skirt of the connector
is flush with the bottom of the plug) into the bottom of
the plug.  The threaded end of the BNC connector protrudes
far enought to allow a lock washer, flat connecting tap, and
a nut to secure the connector in the plug.  Once inserted
into the conduit so that the bottom of the plug is flush
with the bottom of the conduit, the plug may be secured to
the conduit with two small screws that that are screwed into
the opposing sides of the conduit continuing for a short
distance into the sides of the plug.

A version of the PA0DRT Mini-Whip antenna that's currently
being sold on eBay may be soldered to the BNC, the plug
then inserted into the conduit as described above, and a
standard couduit cap placed over the top of the conduit to
provide a secure enclosure for the antenna.

		Melvin G. Seyle, Jr.
			W4MEL
		  August 26, 2015
*/

$fn=100;

cubesize = 25.4;
height   = 130;

 union() {

  difference() {

//  translate([0,0,0])     cube(size = cubesize, c//enter = false);  // main enclosure rectangle

  translate([0,0,0])     cube(size = [cubesize, cubesize, cubesize+104.6], center=false);  // main enclosure rectangle

  // Hollow out the main rectangle  
  translate([3.175,3.175,0]) cube(size = [cubesize-6.35, cubesize-6.35, cubesize+104.6], center=false);

  // Hollow out the main rectangle  
//  translate([3.175,3.175,3.175]) cube(size = [cu//besize-6.35, cubesize-6.35, cubesize-3], center=//false);

  // Lower zip tie hole
  translate([23.225, 0, 98]) cube(size = [2, 25.4, 5.25]);

  // Upper zip tie hole
  translate([23.225, 0, 6]) cube(size = [2, 25.4, 5.25]);

  // Hole for cap screw #1
  translate([18.4,0,126]) rotate([-90,0,0]) cylinder(h=3.18 ,r=0.75);

  // Hole for plug screw #2
  translate([6,25.4,4.5]) rotate([90,0,0]) cylinder(h=3.18 ,r=00.75);

  }
  
  difference() {

   translate([25.4, 0, 0]) cube(size = [4, 25.4,109]);

   polyhedron ( points = [[29.4, 4, 0], [29.4, 4, 109], [29.4, 21.4, 0], [29.4, 21.4, 109], [27.4, 12.2, 0], [27.4, 12.2, 109]], triangles = [[1, 3, 0], [3, 2, 0], [5, 1, 0], [4, 5, 0], [5, 4, 3], [2, 3, 4], [5, 3, 1], [4, 0, 2]]);
 }
}
