
/*
  This file is the design for a plug to fit into the bottom
of a rectangular enclosure for the pa0drt e-field antenna.
  The plug allows a BNC panel connector
to be inserted (inset, so that the skirt of the connector
is flush with the bottom of the plug) into the bottom of
the enclosure.  The threaded end of the BNC connector protrudes
far enought to allow a lock washer, flat connecting tap, and
a nut to secure the connector in the plug.  Once inserted
into the enclosure so that the bottom of the plug is flush
with the bottom, the plug may be secured to
the enclosure with two small screws that that are screwed into
the opposing sides of the enclosure continuing for a short
distance into the sides of the plug.

A version of the pa0drt Mini-Whip antenna that's currently
being sold on eBay may be soldered to the BNC, and the plug
then inserted into the enclosure as described above.

This the version made with ABS filament.

		Melvin G. Seyle, Jr.
			   W4MEL
		September 25, 2015
*/

$fn=100;

cubesize = 18.5; //my starting cubesize = 19.15;

difference() {
 
translate([0, 0, 0]) cube([cubesize, cubesize, 8.5]); // Plug

 // A hole for the BNC connector 
 translate([9.575,9.575,0])     cylinder(r=4.9625,  h=8.5);
 
 // The inset hole for the connector skirt 
 translate([9.575,9.575,5.35]) cylinder(r=7.55,    h=3.175);

  // Hole for plug screw #1
  translate([3.45,18.5,4.25]) rotate([90,0,0]) cylinder(h=3.18 ,r=0.75);

  // Hole for plug screw #2
  //translate([15.05,0,4.25]) rotate([-90,0,0]) cylinder(h=3.18 ,r=00.75);
    
    // Hole for plug screw #2
  translate([3.45,0,4.25]) rotate([-90,0,0]) cylinder(h=3.18 ,r=0.75);

 }
 




